<?xml version="1.0"?>
<!-- Filename with Hits Transform
    Copyright (C) Mythicsoft Ltd 2010. All rights reserved.
    
    Produces output that contains the file name with the unique hits for each file found in a search all on a single line.
	Useful when searching using a large list of potential criteria where only some of the criteria may match,
	e.g. key terms loaded from a file list.
	
	
    -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
			xmlns:rslt="http://www.mythicsoft.com/FileLocator_16Aug2005"
           version="1.0">

  <xsl:output method="text" indent="yes"/>
  <xsl:key name="hits-value" match="rslt:hit" use="concat(../../../rslt:path, ../../../rslt:name, substring(../rslt:text, @rslt:exprstart + 1, @rslt:exprlength))" />

  <xsl:template match="/">
    <xsl:apply-templates select="//rslt:file"/>
  </xsl:template>

  <xsl:template match="rslt:file">
    <xsl:value-of select="rslt:path"/>
    <xsl:value-of select="rslt:name"/>
    <xsl:apply-templates select="rslt:contents/rslt:line/rslt:hit"/>
    <xsl:text>&#13;&#10;</xsl:text>   <!-- CR LF end of line -->
  </xsl:template>
  
  <xsl:template match="rslt:hit">
  	<xsl:if test="generate-id() = generate-id(key('hits-value', concat(../../../rslt:path, ../../../rslt:name, substring(../rslt:text, @rslt:exprstart + 1, @rslt:exprlength)) ))">      
		<xsl:text>&#32;</xsl:text>	<!-- Space separator -->
		
    	<xsl:value-of select="substring(../rslt:text, @rslt:exprstart + 1, @rslt:exprlength)"/>
    </xsl:if>
  </xsl:template>
  

</xsl:stylesheet>